/* ============ */
/* permutst.c	*/
/* ============ */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <miscdefs.h>
#include <pmtndefs.h>
#include <mconf.h>

#define	NUM_PROBS	100
#define LOW_PROB	1.0e-8

static	PRMUT_DATA_STRU  PermuteData;
static	INIT_DATA_STRU   InitialData;

static	double	ChiSqProb[NUM_PROBS];
/* ==================================================================== */
/* PermutationTest - Executes Permutation Test per Knuth, Vol 2, p. 64	*/
/* ==================================================================== */
void
main(void)
{
    int	    k;
    double  DegFree, LoLimit, HiLimit;
    double  KnMinusProb, KnMinusStat, KnPlusProb, KnPlusStat;

    AbortGracefully();			/* Make ^C act reasonably */

    printf("\tP E R M U T A T I O N  T E S T\n\n");
    GetInitialData(&InitialData);
    fprintf(stderr, "\n"); fflush(NULL);

    /* -------------------------- */
    /* Print Initial Data Entries */
    /* -------------------------- */
    printf("Starting Seed = %u%s\n", InitialData.UserSeed,
	(InitialData.SeedSrce == (UINT)(-1)) ?
		" (Unsigned Integer Part of Time of Day)" : "");

    printf("Generator     = %s\n", InitialData.GenName);

    /* -------------------------------------- */
    /* Set Address of Random Number Generator */
    /* -------------------------------------- */
    PermuteData.RandFun = InitialData.RandFun;

    /* -------------------------------------------------- */
    /* Initialize Control Parameters for Permutation Test */
    /* -------------------------------------------------- */
    SetPermuteControls(&PermuteData);

    /* --------------------------- */
    /* Clear Random-Number Counter */
    /* --------------------------- */
    PermuteData.NumVariates = 0;

    printf("%6lu  Random Numbers Will be Generated (Minimum)\n\n",
	(ULONG) PermuteData.NumObs * PermuteData.NumElements * NUM_PROBS);

    DegFree = PermuteData.NumCategories - 1;
    ChiSqDist(LOW_PROB, DegFree, &LoLimit, &HiLimit);

    /* ------------------------- */
    /* Generate Random Numbers,  */
    /* Calculate Chi-Square Data */
    /* ------------------------- */
    fflush(NULL);
    for (k = 0; k < NUM_PROBS; ++k)
    {
	CalcPermuteChiSq(&PermuteData);

	fprintf(stderr, "\rPass %3d (of %d), %8ld  Total Random Numbers",
	    k+1, NUM_PROBS, PermuteData.NumVariates);

	if (PermuteData.PrmutChiSq < LoLimit)
	{
	      ChiSqProb[k] = LOW_PROB;
	}
	else if (PermuteData.PrmutChiSq > HiLimit)
	{
	      ChiSqProb[k] = 1.0 - LOW_PROB;
	}
	else
	{
		ChiSqProb[k] = chdtr(DegFree, PermuteData.PrmutChiSq);
	}

	if (ChiSqProb[k] < 0)
	{
	    fprintf(stderr, "\nChiSqFreq(): Function chdtr() "
		"Returned Negative Probability -  Can't Happen.\n");
	}
	P(printf("Permute Chi-Square Statistic = %f\n",
	   PermuteData.PrmutChiSqStat));
	P(printf("Chi-Square Probability on %.f"
		" Degrees of Freedom = %.4f\n", DegFree, ChiSqProb[k]));
    }
    /* -------------------------------------------------------- */
    /* Calculate K-S on Chi-Square Statistics and Probabilities */
    /* -------------------------------------------------------- */
    fflush(NULL);
    KSCalc(ChiSqProb, NUM_PROBS,
		&KnPlusStat, &KnPlusProb,
 		&KnMinusStat, &KnMinusProb);

    printf("\nResults of Kolmogorov-Smirnov Test "
		"on %d Chi-Square Probabilities:\n", NUM_PROBS);

    printf("\tK(%d)+ = %f (Knuth) or %9f%%\n", NUM_PROBS,
	sqrt((double)NUM_PROBS)*KnPlusStat, 100*KnPlusProb);

    printf("\tK(%d)- = %f (Knuth) or %9f%%\n", NUM_PROBS,
	sqrt((double)NUM_PROBS)*KnMinusStat, 100*KnMinusProb);

    printf("\nThis Run Required %ld Random Numbers\n",
	PermuteData.NumVariates);
}
